﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VRM.Integration.FTP.MVI.Messages
{
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.FTPSelectedPersonResponse)]
    [DataContract]
    public class FTPSelectedPersonResponse : MessageBase
    {
        /// <summary>
        /// For CMRe, all we want back is the URL of the cmre_person that we either found, or that we created.
        /// </summary>
        [DataMember]
        public string URL { get; set; }

        [DataMember]
        public Guid contactId { get; set; }

        [DataMember]
        public bool ExceptionOccured { get; set; }

        [DataMember]
        public string Message { get; set; }

        [DataMember]
        public string RawMviExceptionMessage { get; set; }

        [DataMember]
        public string VeteranSensitivityLevel { get; set; }
    }
}
